<?php
header("Content-Type: application/json");
$filename = "user_data.json"; // ফাইলের নাম পরিবর্তন করুন

// POST রিকোয়েস্ট চেক করুন
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // JSON ফাইলটি রিড করে
    if (!file_exists($filename)) {
        echo json_encode(["message" => "File not found"]);
        exit;
    }

    $jsonData = file_get_contents($filename);
    $data = json_decode($jsonData, true);

    // ইউজারের ডিভাইস আইডি এবং অ্যাকশন গ্রহণ
    $device_id = $_POST['device_id'];
    $action = $_POST['action']; // "approve", "reject", or "delete"

    $isUpdated = false;

    // ডেটার মধ্যে লুপ করে সঠিক ইউজার খুঁজুন
    foreach ($data as &$entry) {
        if ($entry['device_id'] == $device_id) {
            // যদি অ্যাকশন approve হয়
            if ($action == 'approve') {
                $entry['status'] = 'Approved';
                $isUpdated = true;
            } 
            // যদি অ্যাকশন reject হয়
            else if ($action == 'reject') {
                $entry['status'] = 'Rejected';
                $isUpdated = true;
            } 
            // যদি অ্যাকশন delete হয়
            else if ($action == 'delete') {
                unset($entry);
                $isUpdated = true;
            }
        }
    }

    // যদি অ্যাকশন delete হয়, তবে সম্পূর্ণ এন্ট্রি মুছে দিন
    if ($action == 'delete') {
        $data = array_values($data); // Unset করা এন্ট্রিগুলোকে রিইনডেক্স করে
    }

    // যদি কোনো এন্ট্রি পরিবর্তিত হয়, তাহলে JSON ফাইলটি আপডেট করুন
    if ($isUpdated) {
        file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
        echo json_encode(["message" => "Action performed successfully"]);
    } else {
        echo json_encode(["message" => "No matching device ID found"]);
    }
}
?>
