<?php
// Set timezone to Bangladesh
date_default_timezone_set('Asia/Dhaka');

$jsonFile = 'users.json';
$data = json_decode(file_get_contents($jsonFile), true);

// Handle position update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['set_position'])) {
    $id = $_POST['user_id'];
    $position = $_POST['position'];

    // Record approval/rejection date and time
    $data['users'][$id]['approval_date'] = date("d-m-Y h:i A");  // Store approval date in 12-hour format

    $data['users'][$id]['position'] = $position;
    file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: admin.php");
    exit;
}

// Handle adding new user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_user'])) {
    $newUser = [
        'name' => $_POST['name'],
        'email' => $_POST['email'],
        'phone' => $_POST['phone'],
        'dob' => $_POST['dob'],
        'address' => $_POST['address'],
        'status' => 'pending', // Default status
        'position' => '',
        'image_path' => 'default_image.jpg', // Default image if not provided
        'registration_date' => date("d-m-Y h:i A"), // Registration date and time in 12-hour format
    ];

    $data['users'][] = $newUser;
    file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: admin.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Club User Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', sans-serif;
        }

        .user-card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            padding: 20px;
            margin-bottom: 20px;
            transition: 0.3s ease;
        }

        .user-card:hover {
            box-shadow: 0 6px 16px rgba(0,0,0,0.08);
        }

        .user-img {
            width: 90px;
            height: 90px;
            border-radius: 10px;
            object-fit: cover;
            margin-right: 20px;
            cursor: pointer;
            transition: 0.2s ease-in-out;
        }

        .user-img:hover {
            transform: scale(1.05);
        }

        .status-badge {
            font-size: 0.9rem;
            padding: 5px 15px;
            border-radius: 50px;
            color: white;
            text-transform: capitalize;
        }

        .bg-pending {
            background-color: #f39c12;
        }

        .bg-approved {
            background-color: #27ae60;
        }

        .bg-rejected {
            background-color: #e74c3c;
        }

        .action-btns a {
            margin-right: 8px;
            margin-top: 5px;
        }

        .card-header-title {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-body-info p {
            margin: 0 0 5px;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h2 class="mb-4 text-center text-primary">Club User Management</h2>

    <!-- New User Button -->
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addUserModal">
        <i class="fas fa-user-plus"></i> Add New User
    </button>

    <!-- New User Modal -->
    <div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <form method="POST" class="modal-content p-3">
                <div class="modal-header">
                    <h5 class="modal-title">Add New User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label">Name</label>
                        <input type="text" class="form-control" name="name" id="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" id="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="phone" class="form-label">Phone</label>
                        <input type="text" class="form-control" name="phone" id="phone" required>
                    </div>
                    <div class="mb-3">
                        <label for="dob" class="form-label">Date of Birth</label>
                        <input type="date" class="form-control" name="dob" id="dob" required>
                    </div>
                    <div class="mb-3">
                        <label for="address" class="form-label">Address</label>
                        <textarea class="form-control" name="address" id="address" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="add_user" class="btn btn-success">Add User</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>

    <?php foreach ($data['users'] as $index => $user): ?>
        <div class="user-card">
            <div class="row align-items-center">
                <div class="col-md-2 text-center">
                    <img src="<?= $user['image_path'] ?>" class="user-img" alt="User Image"
                         data-bs-toggle="modal" data-bs-target="#imageModal<?= $index ?>">
                </div>

                <div class="col-md-7 card-body-info">
                    <div class="card-header-title">
                        <h5><?= htmlspecialchars($user['name']) ?></h5>
                        <span class="status-badge <?= $user['status'] == 'approved' ? 'bg-approved' : ($user['status'] == 'rejected' ? 'bg-rejected' : 'bg-pending') ?>">
                            <?= $user['status'] ?>
                        </span>
                    </div>
                    <p><strong>Email:</strong> <?= $user['email'] ?></p>
                    <p><strong>Phone:</strong> <?= $user['phone'] ?> 
                        <a href="tel:<?= $user['phone'] ?>" class="ms-2 text-success">
                            <i class="fas fa-phone-square-alt"></i>
                        </a>
                    </p>
                    <p><strong>DOB:</strong> <?= $user['dob'] ?></p>
                    <p><strong>Address:</strong> <?= $user['address'] ?></p>
                    <p><strong>Position:</strong> <?= !empty($user['position']) ? $user['position'] : 'N/A' ?></p>
                    <p><strong>Registration Date:</strong> <?= $user['registration_date'] ?></p>
                    <?php if (isset($user['approval_date'])): ?>
                        <p><strong>Approval Date:</strong> <?= $user['approval_date'] ?></p>
                    <?php endif; ?>
                </div>

                <div class="col-md-3 text-md-end action-btns">
                    <?php if ($user['status'] == 'pending'): ?>
                        <a href="approve.php?id=<?= $index ?>" class="btn btn-sm btn-success">
                            <i class="fas fa-check"></i> Approve
                        </a>
                        <a href="reject.php?id=<?= $index ?>" class="btn btn-sm btn-danger">
                            <i class="fas fa-times"></i> Reject
                        </a>
                    <?php endif; ?>
                    <a href="edit.php?id=<?= $index ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="delete.php?id=<?= $index ?>" class="btn btn-sm btn-outline-danger">
                        <i class="fas fa-trash"></i> Delete
                    </a>

                    <!-- 🔻 Position Button -->
                    <button class="btn btn-sm btn-secondary mt-2" data-bs-toggle="modal" data-bs-target="#positionModal<?= $index ?>">
                        <i class="fas fa-user-tag"></i> Set Position
                    </button>
                </div>
            </div>
        </div>

        <!-- Image Modal -->
        <div class="modal fade" id="imageModal<?= $index ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content p-3">
                    <img src="<?= $user['image_path'] ?>" class="img-fluid rounded" alt="User Image">
                </div>
            </div>
        </div>

        <!-- Position Modal -->
        <div class="modal fade" id="positionModal<?= $index ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <form method="POST" class="modal-content p-3">
                    <div class="modal-header">
                        <h5 class="modal-title">Set Position for <?= htmlspecialchars($user['name']) ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="user_id" value="<?= $index ?>">
                     <select name="position" class="form-select" required>
    <option value="">-- Select Position --</option>
    <option value="প্রধান উপদেষ্টা" <?= ($user['position'] ?? '') == 'প্রধান উপদেষ্টা' ? 'selected' : '' ?>>প্রধান উপদেষ্টা</option>
    <option value="উপদেষ্টা" <?= ($user['position'] ?? '') == 'উপদেষ্টা' ? 'selected' : '' ?>>উপদেষ্টা</option>
    <option value="সভাপতি" <?= ($user['position'] ?? '') == 'সভাপতি' ? 'selected' : '' ?>>সভাপতি</option>
    <option value="সহ-সভাপতি" <?= ($user['position'] ?? '') == 'সহ-সভাপতি' ? 'selected' : '' ?>>সহ-সভাপতি</option>
    <option value="সাধারণ সম্পাদক" <?= ($user['position'] ?? '') == 'সাধারণ সম্পাদক' ? 'selected' : '' ?>>সাধারণ সম্পাদক</option>
    <option value="যুগ্ম সম্পাদক" <?= ($user['position'] ?? '') == 'যুগ্ম সম্পাদক' ? 'selected' : '' ?>>যুগ্ম সম্পাদক</option>
    <option value="সাংগঠনিক সম্পাদক" <?= ($user['position'] ?? '') == 'সাংগঠনিক সম্পাদক' ? 'selected' : '' ?>>সাংগঠনিক সম্পাদক</option>
    <option value="সহ-সাংগঠনিক সম্পাদক" <?= ($user['position'] ?? '') == 'সহ-সাংগঠনিক সম্পাদক' ? 'selected' : '' ?>>সহ-সাংগঠনিক সম্পাদক</option>
    <option value="অর্থ সম্পাদক" <?= ($user['position'] ?? '') == 'অর্থ সম্পাদক' ? 'selected' : '' ?>>অর্থ সম্পাদক</option>
    <option value="সহ-অর্থ সম্পাদক" <?= ($user['position'] ?? '') == 'সহ-অর্থ সম্পাদক' ? 'selected' : '' ?>>সহ-অর্থ সম্পাদক</option>
    <option value="প্রচার সম্পাদক" <?= ($user['position'] ?? '') == 'প্রচার সম্পাদক' ? 'selected' : '' ?>>প্রচার সম্পাদক</option>
    <option value="দপ্তর সম্পাদক" <?= ($user['position'] ?? '') == 'দপ্তর সম্পাদক' ? 'selected' : '' ?>>দপ্তর সম্পাদক</option>
    <option value="ক্রীড়া সম্পাদক" <?= ($user['position'] ?? '') == 'ক্রীড়া সম্পাদক' ? 'selected' : '' ?>>ক্রীড়া সম্পাদক</option>
    <option value="সাংস্কৃতিক সম্পাদক" <?= ($user['position'] ?? '') == 'সাংস্কৃতিক সম্পাদক' ? 'selected' : '' ?>>সাংস্কৃতিক সম্পাদক</option>
    <option value="শিক্ষা ও গবেষণা সম্পাদক" <?= ($user['position'] ?? '') == 'শিক্ষা ও গবেষণা সম্পাদক' ? 'selected' : '' ?>>শিক্ষা ও গবেষণা সম্পাদক</option>
    <option value="স্বাস্থ্য ও পরিবেশ সম্পাদক" <?= ($user['position'] ?? '') == 'স্বাস্থ্য ও পরিবেশ সম্পাদক' ? 'selected' : '' ?>>স্বাস্থ্য ও পরিবেশ সম্পাদক</option>
    <option value="তথ্য ও প্রযুক্তি সম্পাদক" <?= ($user['position'] ?? '') == 'তথ্য ও প্রযুক্তি সম্পাদক' ? 'selected' : '' ?>>তথ্য ও প্রযুক্তি সম্পাদক</option>
    <option value="নারী বিষয়ক সম্পাদক" <?= ($user['position'] ?? '') == 'নারী বিষয়ক সম্পাদক' ? 'selected' : '' ?>>নারী বিষয়ক সম্পাদক</option>
    <option value="আইন বিষয়ক সম্পাদক" <?= ($user['position'] ?? '') == 'আইন বিষয়ক সম্পাদক' ? 'selected' : '' ?>>আইন বিষয়ক সম্পাদক</option>
    <option value="সদস্য" <?= ($user['position'] ?? '') == 'সদস্য' ? 'selected' : '' ?>>সদস্য</option>
</select>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" name="set_position" class="btn btn-success">Save</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>

    <?php endforeach; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
