<?php

// ইউজারের JSON ডেটা গ্রহণ করা
$raw_data = file_get_contents("php://input");

// JSON ডেটা ডিকোড করা
$data = json_decode($raw_data, true);

// ইউজারের তথ্য
$device_id = $data['device_id'];
$device_model = $data['device_model'];
$device_os = $data['device_os'];
$app_version = $data['app_version'];
$login_count = $data['login_count'];
$last_login = $data['last_login'];

// JSON ডেটা একটি ফাইলে সেভ করা
$file = 'user_data.json';

// চেক করা যদি ফাইলটি এক্সিস্ট না করে তাহলে নতুন ফাইল তৈরি করা
if (!file_exists($file)) {
    file_put_contents($file, json_encode([])); // ফাইল তৈরি হবে এবং খালি অ্যারে থাকবে
}

// ফাইল থেকে পুরনো ডেটা পড়া
$file_data = file_get_contents($file);
$json_data = json_decode($file_data, true);

// ডিভাইস আইডি অনুযায়ী ডেটা খুঁজে পাওয়া
$device_found = false;

foreach ($json_data as $key => $user) {
    if ($user['device_id'] == $device_id) {
        // একই ডিভাইস আইডি পাওয়া গেলে, ডেটা আপডেট করা
        $json_data[$key]['login_count'] = $login_count;
        $json_data[$key]['last_login'] = $last_login;
        $json_data[$key]['device_model'] = $device_model;
        $json_data[$key]['device_os'] = $device_os;
        $json_data[$key]['app_version'] = $app_version;

        $device_found = true;
        break;
    }
}

// যদি নতুন ডিভাইস আইডি হয়, তাহলে নতুন ডেটা যুক্ত করা
if (!$device_found) {
    $new_user_data = [
        'device_id' => $device_id,
        'device_model' => $device_model,
        'device_os' => $device_os,
        'app_version' => $app_version,
        'login_count' => $login_count,
        'last_login' => $last_login
    ];

    array_push($json_data, $new_user_data);
}

// মোট ডিভাইস এবং লগইন কাউন্ট হিসেব করা
$total_devices = count($json_data);
$total_login_count = 0;

// লগইন কাউন্টের মোট যোগফল হিসেব করা
foreach ($json_data as $user) {
    $total_login_count += $user['login_count'];
}

// আপডেটেড ডেটা JSON ফরম্যাটে ফাইলে সেভ করা
file_put_contents($file, json_encode($json_data, JSON_PRETTY_PRINT));

// হেডার সেট করা যাতে JSON আউটপুট সঠিকভাবে দেখা যায়
header('Content-Type: application/json');

// ফলাফল প্রদর্শন
$response = [
    'total_devices' => $total_devices,
    'total_login_count' => $total_login_count,
    'devices' => $json_data
];

echo json_encode($response, JSON_PRETTY_PRINT);

?>
