<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>M3U8 Player</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .player-container {
            background: #ffffff;
            border: 2px solid #007BFF;
            border-radius: 15px;
            padding: 20px;
            width: 600px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .player-header {
            font-size: 20px;
            font-weight: bold;
            text-align: center;
            color: #007BFF;
            margin-bottom: 15px;
        }
        video {
            width: 100%;
            border-radius: 10px;
            outline: none;
        }
        .input-group {
            margin-top: 15px;
            display: flex;
            flex-direction: column;
        }
        .input-group label {
            margin-bottom: 5px;
            font-weight: bold;
        }
        .input-group input {
            padding: 10px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            margin-bottom: 10px;
        }
        .play-btn {
            background-color: #007BFF;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 15px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .play-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="player-container">
        <div class="player-header">M3U8 Link Player</div>
        <?php
        // ডিফল্ট লিংক
        $default_link = "https://test-streams.mux.dev/x36xhzz/x36xhzz.m3u8";
        $link = isset($_POST['m3u8_link']) ? htmlspecialchars($_POST['m3u8_link']) : $default_link;
        ?>
        <video controls autoplay>
            <source src="<?php echo $link; ?>" type="application/vnd.apple.mpegurl">
            Your browser does not support the video tag.
        </video>
        <form method="POST" class="input-group">
            <label for="m3u8_link">Enter M3U8 Link:</label>
            <input type="text" id="m3u8_link" name="m3u8_link" placeholder="e.g., https://example.com/stream.m3u8" value="<?php echo $link; ?>" required>
            <button type="submit" class="play-btn">Play</button>
        </form>
    </div>
</body>
</html>
