<?php
function getDirectDownloadLink($sharedUrl) {
    // Initialize a cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $sharedUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Allow redirection
    curl_setopt($ch, CURLOPT_HEADER, false);

    // Set User-Agent (optional, can help with bypassing restrictions)
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36"
    ]);

    // Execute the cURL request
    $response = curl_exec($ch);

    // Check for cURL errors
    if (curl_errno($ch)) {
        return "Error: " . curl_error($ch);
    }

    // Get the final URL after redirection
    $finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);

    // Close the cURL session
    curl_close($ch);

    // Return the direct download link
    return $finalUrl;
}

// Example usage
$sharedUrl = "https://1024terabox.com/s/1XFED4KoDgfKk2nDJRtxhnw"; // Replace with your shared URL
$directLink = getDirectDownloadLink($sharedUrl);

echo "Direct Download Link: " . $directLink;
?>