<?php

// UDP Socket তৈরি করা
$socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
if (!$socket) {
    die("সকেট তৈরি করতে ব্যর্থ: " . socket_strerror(socket_last_error()));
}

// ব্রডকাস্ট করার জন্য ঠিকানা
$multicastAddr = "239.255.255.250"; // SSDP মাল্টিকাস্ট অ্যাড্রেস
$multicastPort = 1900;

// SSDP বার্তা তৈরি
$ssdpMessage = "NOTIFY * HTTP/1.1\r\n" .
    "HOST: $multicastAddr:$multicastPort\r\n" .
    "NT: upnp:rootdevice\r\n" .
    "NTS: ssdp:alive\r\n" .
    "USN: uuid:your-device-uuid::upnp:rootdevice\r\n" .
    "LOCATION: http://192.168.1.2:8080/description.xml\r\n" .
    "CACHE-CONTROL: max-age=1800\r\n" .
    "SERVER: PHP/SSDP\r\n\r\n";

// বার্তা পাঠানো
if (!socket_set_option($socket, SOL_SOCKET, SO_BROADCAST, 1)) {
    die("ব্রডকাস্ট অপশন সেট করতে ব্যর্থ: " . socket_strerror(socket_last_error()));
}

if (!socket_sendto($socket, $ssdpMessage, strlen($ssdpMessage), 0, $multicastAddr, $multicastPort)) {
    die("বার্তা পাঠাতে ব্যর্থ: " . socket_strerror(socket_last_error()));
}

echo "SSDP বার্তা ব্রডকাস্ট করা হয়েছে।\n";

// সকেট বন্ধ
socket_close($socket);