<?php
session_start();
header('Cache-Control: no-cache, no-store, must-revalidate');

$error = '';

$adminPassword = getenv('ADMIN_PASSWORD');
if (empty($adminPassword)) {
    die('Error: ADMIN_PASSWORD environment variable must be set. Please configure it in your secrets.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    
    if ($password === $adminPassword) {
        session_regenerate_id(true);
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['login_time'] = time();
        header('Location: index.php');
        exit;
    } else {
        $error = 'ভুল পাসওয়ার্ড! আবার চেষ্টা করুন।';
    }
}

if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>লগইন - টিক টক ভিডিও ডাউনলোডার অ্যাডমিন</title>
    <link rel="icon" type="image/svg+xml" href="favicon.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/style.css">
    <style>
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-box {
            background: var(--card-bg);
            border-radius: 20px;
            border: 1px solid var(--border-color);
            padding: 40px;
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        .login-box h1 {
            color: var(--primary-color);
            margin-bottom: 10px;
            font-size: 1.8rem;
        }
        .login-box h1 i {
            margin-right: 10px;
        }
        .login-box p {
            color: var(--text-muted);
            margin-bottom: 30px;
        }
        .login-box .form-group {
            margin-bottom: 25px;
            text-align: left;
        }
        .login-box .btn {
            width: 100%;
            justify-content: center;
            padding: 15px;
            font-size: 1.1rem;
        }
        .login-error {
            background: rgba(255, 82, 82, 0.1);
            border: 1px solid var(--danger-color);
            color: var(--danger-color);
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <h1><i class="fab fa-tiktok"></i>টিক টক ডাউনলোডার</h1>
            <p>অ্যাডমিন প্যানেলে প্রবেশ করতে পাসওয়ার্ড দিন</p>
            
            <?php if (!empty($error)): ?>
            <div class="login-error">
                <i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($error) ?>
            </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="password">পাসওয়ার্ড</label>
                    <input type="password" class="form-control" id="password" name="password" placeholder="আপনার পাসওয়ার্ড লিখুন..." required autofocus>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt"></i>
                    লগইন করুন
                </button>
            </form>
        </div>
    </div>
</body>
</html>
